/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.HexDump;
import com.ibm.hsc.common.util.PIBuildCommandPacket;
import com.ibm.hsc.common.util.PIParseResponse;
import com.ibm.hsc.common.util.PropertiesLoader;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PILLCmd {
    Socket m_hdwr_svrSocket = null;
    DataInputStream m_socketInput = null;
    DataOutputStream m_socketOutput = null;
    boolean m_isRegistered = false;
    String m_vPort = null;
    String m_MTMS = "MY_CEC";
    String m_dataFile = null;
    String m_shell = null;
    Properties m_commandProperties = null;
    Properties m_pillCmdProperties = null;
    private int m_Count = 0;
    Vector m_cecVector = new Vector();

    private PILLCmd() {
        this.initialize();
    }

    private void closeSocket() {
        if (this.m_hdwr_svrSocket != null) {
            try {
                this.m_hdwr_svrSocket.close();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public PILLCmd(String string, String string2, String string3) {
        this.m_vPort = string;
        this.m_dataFile = string2;
        this.m_shell = string3;
        this.initialize();
    }

    private void initialize() {
        try {
            this.m_commandProperties = PropertiesLoader.openPropFile("/opt/hsc/data/PIHSCCommandPropFile");
            while (this.m_hdwr_svrSocket == null) {
                try {
                    this.m_hdwr_svrSocket = new Socket(InetAddress.getLocalHost(), 8877);
                    this.m_socketInput = new DataInputStream(this.m_hdwr_svrSocket.getInputStream());
                    this.m_socketOutput = new DataOutputStream(this.m_hdwr_svrSocket.getOutputStream());
                }
                catch (IOException iOException) {
                    System.out.println("Connection failed to hardware server.  Trying again...");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error: PIHSCCommandPropFile, Property File Not found....");
            System.exit(1);
        }
        try {
            this.m_pillCmdProperties = PropertiesLoader.openPropFile("/opt/hsc/data/PILLCmdPropFile");
        }
        catch (Exception exception) {
            System.out.println("Warning: Unable to use Smart Mode - PILLCmdPropFile is not found.");
        }
    }

    public void prepareCommand() {
        String[] stringArray = this.listCecs();
        if ((this.m_vPort == null || this.m_dataFile == null) && this.m_shell == null) {
            System.out.println("Usage:  PILLCmd [-vport PORT# -df DataFile] | [-shell] \n\nThe datafile contains the Hex data you wish to send.\nYou must specify the vport and mtms of the system.\nThe following is a list of CECs known to hardware server:\n");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
        } else if (this.m_shell != null) {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            System.out.println("\nHMC Low Level Command Line Shell -- DO NOT SHIP!!!");
            System.out.println("__________________________________________________\n");
            System.out.println("List of Online CECs\n");
            for (n = 0; n < stringArray.length; ++n) {
                System.out.println(n + 1 + "\n" + stringArray[n]);
            }
            System.out.print("\nEnter the number of the CEC to which you wish to connect.\nEnter Number ->");
            n = -1;
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    try {
                        n = Integer.parseInt(string);
                        if (n > 0 && n <= stringArray.length) {
                            --n;
                            break;
                        }
                        System.out.print("Invalid number.  Try again.\nEnter Number ->");
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.print("Invalid number.  Try again.\nEnter Number ->");
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
            String[] stringArray2 = (String[])this.m_cecVector.elementAt(n);
            this.m_MTMS = stringArray2[0];
            this.m_vPort = stringArray2[1];
            this.switch_modes();
        } else {
            this.runCommand();
        }
    }

    private void fileCommand(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("ERROR: invalid cec number");
            System.exit(1);
        }
        String[] stringArray = this.listCecs();
        if (--n >= stringArray.length) {
            System.out.println("ERROR: invalid cec number");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(i + 1 + ": " + stringArray[i]);
            }
            System.exit(1);
        } else {
            String[] stringArray2 = (String[])this.m_cecVector.elementAt(n);
            this.m_MTMS = stringArray2[0];
            this.m_vPort = stringArray2[1];
            this.runCommand();
        }
    }

    private void switch_modes() {
        System.out.println("\nEnter the Command Entry Mode < 1: Manual,  2: File,  3: Smart > ");
        System.out.print("Enter Mode ->");
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = null;
        int n = 0;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                try {
                    n = Integer.parseInt(string);
                    if (n <= 0 || n >= 4) {
                        System.out.print("Invalid number.  Try again.\nEnter Mode ->");
                    }
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.print("Invalid number.  Try again.\nEnter Mode ->");
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        switch (n) {
            case 1: {
                this.ManualEntryMode();
                break;
            }
            case 2: {
                this.FileEntryMode();
                break;
            }
            case 3: {
                this.SmartEntryMode();
            }
        }
    }

    private void ManualEntryMode() {
        System.out.print("\nYOU ARE IN MANUAL ENTRTY MODE (Hidden Commands: switch, quit) ");
        System.out.print("\nEnter Command Manually (without spaces)");
        System.out.print("\n->");
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if ("exit".equalsIgnoreCase(string) || "quit".equalsIgnoreCase(string)) {
                    System.exit(0);
                } else if ("switch".equalsIgnoreCase(string)) {
                    this.switch_modes();
                } else if (string.length() > 1) {
                    this.runManualCommand(string);
                } else {
                    System.out.println("Error: Either Command is Invalid format  ");
                    System.out.println("       or, Command length is not divisible by 2");
                    System.out.println("       or, Command contains No. of bytes less than 40\n");
                }
                System.out.print("\nEnter Command Manually(without spaces)");
                System.out.print("\n->");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        System.exit(1);
    }

    private void FileEntryMode() {
        System.out.print("\nYOU ARE IN FILE ENTRY MODE ( Hidden Commands: list,switch,quit)");
        System.out.println("\nEnter the file that contains the command packet.");
        System.out.print("->");
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if ("exit".equalsIgnoreCase(string) || "quit".equalsIgnoreCase(string)) {
                    System.exit(0);
                } else if ("switch".equalsIgnoreCase(string)) {
                    this.switch_modes();
                } else if (string.length() > 1) {
                    if (string.startsWith("ls ") || string.startsWith("list ") || string.equalsIgnoreCase("ls") || string.equalsIgnoreCase("list")) {
                        String string2 = "./";
                        int n = string.indexOf(32);
                        if (n != -1 && n != string.length()) {
                            string2 = string.substring(n + 1);
                        }
                        this.displayCurrentDirFiles(string2);
                    } else {
                        this.m_dataFile = string;
                        this.runCommand();
                    }
                }
                System.out.println("\nEnter the file that contains the command packet.");
                System.out.print("->");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private void SmartEntryMode() {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = null;
        System.out.print("\nYOU ARE IN SMART ENTRY MODE (Hidden Commands: switch, quit) ");
        System.out.println("\n\n Enter the Command <from PIHSCCommandPropFile> ");
        System.out.print("->");
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if ("exit".equalsIgnoreCase(string) || "quit".equalsIgnoreCase(string)) {
                    System.exit(0);
                } else if ("switch".equalsIgnoreCase(string)) {
                    this.switch_modes();
                } else if (string.length() > 3 && this.isValidCommand(string)) {
                    String string2 = (String)this.m_commandProperties.get(string);
                    System.out.println("  " + string + " = " + string2);
                    String[] stringArray = this.getParameterFormats(string);
                    String[] stringArray2 = new String[stringArray.length];
                    String string3 = null;
                    for (int i = 0; i < stringArray.length; ++i) {
                        System.out.print("Enter  " + stringArray[i] + " > ");
                        string3 = bufferedReader.readLine();
                        if (string3 == null) continue;
                        if ("exit".equalsIgnoreCase(string3) || "quit".equalsIgnoreCase(string3)) {
                            System.exit(0);
                            continue;
                        }
                        if (string3.length() <= 0) continue;
                        stringArray2[i] = string3;
                        System.out.println("\n params = " + stringArray2[i]);
                    }
                    this.runSmartCommand(string, stringArray2);
                } else {
                    System.out.println("Error: Command is not found in Property File  ");
                    System.out.println("       Check the Command properly and re-enter again.. ");
                }
                System.out.println("\n\n Enter the Command <from PIHSCCommandPropFile> ");
                System.out.print("->");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private String[] listCecs() {
        Object object;
        Vector<String> vector = new Vector<String>();
        try {
            int n;
            int n2;
            object = HardwareServerMessage.buildHSFspQuery();
            byte[] byArray = ((HardwareServerMessage)object).toBytes();
            this.m_socketOutput.write(byArray, 0, byArray.length);
            this.m_socketOutput.flush();
            object = new HardwareServerMessage(this.m_socketInput);
            byte[] byArray2 = ((HardwareServerMessage)object).toBytes();
            int n3 = (((byArray2[7] & 0xFF) << 8) + (byArray2[6] & 0xFF)) / 4;
            long[] lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                n = 30 + n2 * 4;
                lArray[n2] = (((long)byArray2[n + 3] & 0xFFL) << 24) + (((long)byArray2[n + 2] & 0xFFL) << 16) + (((long)byArray2[n + 1] & 0xFFL) << 8) + ((long)byArray2[n] & 0xFFL);
            }
            for (n2 = 0; n2 < lArray.length; ++n2) {
                object = HardwareServerMessage.buildFspDataQuery((int)lArray[n2]);
                byArray = ((HardwareServerMessage)object).toBytes();
                this.m_socketOutput.write(byArray, 0, byArray.length);
                this.m_socketOutput.flush();
                object = new HardwareServerMessage(this.m_socketInput);
                byArray2 = ((HardwareServerMessage)object).toBytes();
                n = ((byArray2[7] & 0xFF) << 8) + (byArray2[6] & 0xFF);
                int n4 = ((byArray2[31] & 0xFF) << 8) + (byArray2[30] & 0xFF);
                String string = new String(byArray2, 30 + n4, n - n4);
                String string2 = "\tCEC MTMS:  " + string.trim() + "\n" + "\tCEC VPort: " + lArray[n2] + "\n" + "___________________________________\n";
                vector.addElement(string2);
                this.m_cecVector.addElement(new String[]{string.trim(), "" + lArray[n2]});
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private void runCommand() {
        Socket socket = this.m_hdwr_svrSocket;
        System.out.println("mtms = " + this.m_MTMS + "  vport = " + this.m_vPort);
        try {
            Object object;
            DataOutputStream dataOutputStream = this.m_socketOutput;
            DataInputStream dataInputStream = this.m_socketInput;
            File file = new File(this.m_dataFile);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Vector<Byte> vector = new Vector<Byte>();
            String string = bufferedReader.readLine();
            while (string != null) {
                object = new StringTokenizer(string);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    if (string2.length() % 2 != 0) {
                        System.out.println("Error:  Invalid data file format. Token " + string2 + " not divisible by 2");
                        return;
                    }
                    for (int i = 0; i < string2.length(); i += 2) {
                        try {
                            int n = Integer.parseInt(string2.substring(i, i + 2), 16);
                            vector.addElement(new Byte((byte)n));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Error:  Invalid data file format.\n" + string2.substring(i, i + 2) + " cannot be converted to a byte");
                            return;
                        }
                    }
                }
                string = bufferedReader.readLine();
            }
            if (vector.size() < 1) {
                System.out.println("Error:  The datafile contained no data");
                return;
            }
            object = new byte[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                object[i] = (Byte)vector.elementAt(i);
            }
            HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildFspPassthrough(Integer.parseInt(this.m_vPort), this.m_Count++, (byte[])object);
            object = hardwareServerMessage.toBytes();
            System.out.println("Sending...\n" + new HexDump((byte[])object, true));
            dataOutputStream.write((byte[])object, 0, ((Object)object).length);
            dataOutputStream.flush();
            hardwareServerMessage = new HardwareServerMessage(dataInputStream);
            System.out.println("hdwr_svr response = " + new HexDump(hardwareServerMessage.toBytes(), true));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("The datafile " + this.m_dataFile + " was not found.  Please check the filename");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void runManualCommand(String string) {
        Socket socket = this.m_hdwr_svrSocket;
        System.out.println("mtms = " + this.m_MTMS + "  vport = " + this.m_vPort);
        try {
            int n;
            DataOutputStream dataOutputStream = this.m_socketOutput;
            DataInputStream dataInputStream = this.m_socketInput;
            Vector<Byte> vector = new Vector<Byte>();
            string.trim();
            if (string.length() % 2 != 0 || string.length() < 40) {
                System.out.println("Error: Either Command is Invalid format  ");
                System.out.println("       or, Command length is not divisible by 2");
                System.out.println("       or, Command contains No. of bytes less than 40");
                return;
            }
            for (int i = 0; i < string.length(); i += 2) {
                try {
                    n = Integer.parseInt(string.substring(i, i + 2), 16);
                    vector.addElement(new Byte((byte)n));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Error:  Invalid data file format.\n" + string.substring(i, i + 1) + " cannot be converted to a byte");
                }
            }
            byte[] byArray = new byte[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                byArray[n] = (Byte)vector.elementAt(n);
            }
            HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildFspPassthrough(Integer.parseInt(this.m_vPort), this.m_Count++, byArray);
            byArray = hardwareServerMessage.toBytes();
            System.out.println("Sending...\n" + new HexDump(byArray, true));
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.flush();
            hardwareServerMessage = new HardwareServerMessage(dataInputStream);
            System.out.println("hdwr_svr response = " + new HexDump(hardwareServerMessage.toBytes(), true));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("..........");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private boolean isValidCommand(String string) {
        String string2 = (String)this.m_commandProperties.get(string);
        return string2 != null;
    }

    private String[] getParameterFormats(String string) {
        String string2 = (String)this.m_pillCmdProperties.get(string);
        if (string2 != null) {
            Object[] objectArray = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "+");
                Vector<String> vector = new Vector<String>(stringTokenizer2.countTokens());
                while (stringTokenizer2.hasMoreTokens()) {
                    String string4 = stringTokenizer2.nextToken();
                    if (string4.startsWith("PAD")) continue;
                    vector.addElement(string4);
                }
                vector.trimToSize();
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
            return null;
        }
        System.out.println("\n Ooops! this is null string-- method: getParameterFormats ");
        return null;
    }

    private void displayCurrentDirFiles(String string) {
        int n;
        int n2;
        File file;
        Object[] objectArray;
        if (string == null || string.length() < 1) {
            string = "./";
        }
        if ((objectArray = (file = new File(string)).list()) == null) {
            System.out.println("Invalid directory name: " + string);
            return;
        }
        Arrays.sort(objectArray);
        int n3 = objectArray.length / 2;
        int n4 = n3++;
        if (objectArray.length % 2 != 0) {
            // empty if block
        }
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (((String)objectArray[n2]).length() <= n5) continue;
            n5 = ((String)objectArray[n2]).length();
        }
        n2 = 0;
        for (n = n3; n < objectArray.length; ++n) {
            if (((String)objectArray[n]).length() <= n2) continue;
            n2 = ((String)objectArray[n]).length();
        }
        n = 1;
        if (n5 + n2 + 2 > 80) {
            n = 0;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (n != 0) {
            for (int i = 0; i < n3; ++i) {
                stringBuffer.append((String)objectArray[i]);
                for (int j = ((String)objectArray[i]).length(); j < n5 + 2; ++j) {
                    stringBuffer.append(' ');
                }
                if (i + n3 >= objectArray.length) continue;
                stringBuffer.append((String)objectArray[i + n3]).append("\n");
            }
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append((String)objectArray[i]).append("\n");
            }
        }
        System.out.println(stringBuffer.toString());
    }

    private void runSmartCommand(String string, String[] stringArray) {
        Socket socket = this.m_hdwr_svrSocket;
        System.out.println("mtms = " + this.m_MTMS + "  vport = " + this.m_vPort);
        try {
            PIParseResponse pIParseResponse;
            Object var4_4 = null;
            Object var5_7 = null;
            byte[] byArray = PIBuildCommandPacket.buildCommand(string, stringArray, null);
            HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildFspPassthrough(Integer.parseInt(this.m_vPort), this.m_Count++, byArray);
            byte[] byArray2 = hardwareServerMessage.toBytes();
            this.m_socketOutput.write(byArray2, 0, byArray2.length);
            this.m_socketOutput.flush();
            hardwareServerMessage = new HardwareServerMessage(this.m_socketInput);
            System.out.println("hdwr_svr response = " + new HexDump(hardwareServerMessage.toBytes(), true));
            int n = hardwareServerMessage.getMinorOpCode();
            int n2 = hardwareServerMessage.getMajorOpCode();
            if (n2 == 80 && n == 97 && (pIParseResponse = new PIParseResponse(hardwareServerMessage.getPayload())).isNoErrorStatusResponse()) {
                Hashtable hashtable = pIParseResponse.getParsedData(string);
                System.out.print("..printing... HashTable = " + hashtable);
            }
        }
        catch (PIHscServerException pIHscServerException) {
            pIHscServerException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static final void usage() {
        String[] stringArray = new String[]{"-cec: cec number to connect (default = 1)", "-df: run in file with the specified file", "-list: list MTMS connections", "-vport: virtual port (must also specify -mtms", "-shell: run in interactive mode"};
        PILLCmd pILLCmd = new PILLCmd();
        String string = pILLCmd.getClass().getName();
        String string2 = "java " + string + " [-shell | -df file -vport port | -list]";
        System.out.println("USAGE:\n" + string2);
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("\t" + stringArray[i]);
        }
        System.exit(1);
    }

    private static void showCECList() {
        PILLCmd pILLCmd = new PILLCmd();
        String[] stringArray = pILLCmd.listCecs();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(i + 1 + ": " + stringArray[i]);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        PILLCmd pILLCmd = null;
        try {
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if ("-vport".equalsIgnoreCase(stringArray[i]) && stringArray.length > i + 1) {
                        string = stringArray[++i];
                        continue;
                    }
                    if ("-df".equalsIgnoreCase(stringArray[i]) && stringArray.length > i + 1) {
                        string2 = stringArray[++i];
                        continue;
                    }
                    if ("-shell".equalsIgnoreCase(stringArray[i])) {
                        string3 = stringArray[i];
                        continue;
                    }
                    if ("-cec".equalsIgnoreCase(stringArray[i])) {
                        string4 = stringArray[++i];
                        continue;
                    }
                    if ("-list".equalsIgnoreCase(stringArray[i])) {
                        PILLCmd.showCECList();
                        continue;
                    }
                    if ("-h".equalsIgnoreCase(stringArray[i])) {
                        PILLCmd.usage();
                        continue;
                    }
                    if ("--help".equalsIgnoreCase(stringArray[i])) {
                        PILLCmd.usage();
                        continue;
                    }
                    PILLCmd.usage();
                }
            } else {
                string3 = "-shell";
            }
            pILLCmd = new PILLCmd(string, string2, string3);
            if (null != string4) {
                pILLCmd.fileCommand(string4);
            } else {
                pILLCmd.prepareCommand();
            }
            if (pILLCmd != null) {
                pILLCmd.closeSocket();
            }
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                if (pILLCmd != null) {
                    pILLCmd.closeSocket();
                }
            }
            catch (Throwable throwable2) {
                if (pILLCmd != null) {
                    super.closeSocket();
                }
                throw throwable2;
            }
        }
    }
}

